<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'image', 'description', 'themes_id', 'location', 'scheduled_publish_date', 'active');

    public function clubs()
    {
        return $this->belongsTo('Club');
    }

}